/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.wizard.comparedisks;

import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.swt.wizard.WizardPane;
import com.webcodepro.applecommander.ui.swt.wizard.comparedisks.CompareDisksResultsPane;
import com.webcodepro.applecommander.ui.swt.wizard.comparedisks.CompareDisksWizard;
import com.webcodepro.applecommander.util.TextBundle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class CompareDisksStartPane
extends WizardPane {
    private TextBundle textBundle = UiBundle.getInstance();
    private Composite parent;
    private Object layoutData;
    private Composite control;
    private CompareDisksWizard wizard;
    private Text diskname1Text;
    private Text diskname2Text;

    public CompareDisksStartPane(Composite parent, CompareDisksWizard wizard, Object layoutData) {
        this.parent = parent;
        this.wizard = wizard;
        this.layoutData = layoutData;
    }

    @Override
    public void open() {
        this.control = new Composite(this.parent, 0);
        this.control.setLayoutData(this.layoutData);
        this.wizard.enableNextButton(true);
        this.wizard.enableFinishButton(false);
        RowLayout layout = new RowLayout(512);
        layout.justify = true;
        layout.marginBottom = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        layout.marginTop = 5;
        layout.spacing = 3;
        this.control.setLayout(layout);
        Label label = new Label(this.control, 64);
        label.setText(this.textBundle.get("CompareDisksStartPane.Description"));
        label = new Label(this.control, 64);
        label.setText(this.getDiskLabel(1));
        this.diskname1Text = new Text(this.control, 2112);
        if (this.wizard.getDiskname1() != null) {
            this.diskname1Text.setText(this.wizard.getDiskname1());
        }
        this.diskname1Text.setLayoutData(new RowData(300, -1));
        this.diskname1Text.setBackground(new Color(this.control.getDisplay(), 255, 255, 255));
        this.diskname1Text.setFocus();
        this.diskname1Text.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent event) {
                Text text = (Text)event.getSource();
                CompareDisksStartPane.this.getWizard().setDiskname1(text.getText());
            }
        });
        Button button = new Button(this.control, 8);
        button.setText(this.textBundle.get("BrowseButton"));
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(CompareDisksStartPane.this.getControl().getShell());
                fileDialog.setFilterPath(CompareDisksStartPane.this.getDiskname1Text().getText());
                fileDialog.setText(CompareDisksStartPane.this.getDiskLabel(1));
                String filename = fileDialog.open();
                if (filename != null) {
                    CompareDisksStartPane.this.getDiskname1Text().setText(filename);
                }
            }
        });
        label = new Label(this.control, 64);
        label.setText(this.getDiskLabel(2));
        this.diskname2Text = new Text(this.control, 2112);
        if (this.wizard.getDiskname2() != null) {
            this.diskname2Text.setText(this.wizard.getDiskname2());
        }
        this.diskname2Text.setLayoutData(new RowData(300, -1));
        this.diskname2Text.setBackground(new Color(this.control.getDisplay(), 255, 255, 255));
        this.diskname2Text.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent event) {
                Text text = (Text)event.getSource();
                CompareDisksStartPane.this.getWizard().setDiskname2(text.getText());
            }
        });
        button = new Button(this.control, 8);
        button.setText(this.textBundle.get("BrowseButton"));
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(CompareDisksStartPane.this.getControl().getShell());
                fileDialog.setFilterPath(CompareDisksStartPane.this.getDiskname2Text().getText());
                fileDialog.setText(CompareDisksStartPane.this.getDiskLabel(2));
                String filename = fileDialog.open();
                if (filename != null) {
                    CompareDisksStartPane.this.getDiskname2Text().setText(filename);
                }
            }
        });
    }

    @Override
    public WizardPane getNextPane() {
        return new CompareDisksResultsPane(this.parent, this.wizard, this.layoutData);
    }

    @Override
    public void dispose() {
        this.control.dispose();
        this.control = null;
    }

    protected Composite getControl() {
        return this.control;
    }

    protected Text getDiskname1Text() {
        return this.diskname1Text;
    }

    protected Text getDiskname2Text() {
        return this.diskname2Text;
    }

    protected CompareDisksWizard getWizard() {
        return this.wizard;
    }

    protected String getDiskLabel(int diskNumber) {
        return this.textBundle.format("CompareDisksStartPane.DiskNLabel", new Object[]{new Integer(diskNumber)});
    }
}

